
/*! \file CE2_Config.h
    \brief This file defines the options 
*/


#ifndef _CE2_CONFIG_H
#define _CE2_CONFIG_H

#ifndef QAT_CRYPTOENGINE2_EXPORTS
#define CIMPORT_C __declspec(dllimport)
#else
#define CIMPORT_C __declspec(dllexport)
#endif

#ifndef CEXPORT_C
#define CEXPORT_C __declspec(dllexport)
#endif

//Temporary definition:
#ifndef LTM_DESC
#define LTM_DESC
#endif

#define MAX_ECPKI_PUBLIC_KEY_BUFFER_SIZE 256
#define MAX_ECPKI_PRIVATE_KEY_BUFFER_SIZE 256

//typedef unsigned int CE2_PKCS1_version;
typedef unsigned int CE2_RSAPrimeData_t;

/* PKCS1 version definitions */
//#define CE2_PKCS1_VER15	1
//#define CE2_PKCS1_VER21	2

typedef struct CE2_ECPKI_PublKey_t {
  DxUint8_t PublKeyBuffer[MAX_ECPKI_PUBLIC_KEY_BUFFER_SIZE];
} CE2_ECPKI_PublKey_t;

typedef struct CE2_ECPKI_PrivKey_t {
  DxUint8_t PrivKeyBuffer[MAX_ECPKI_PRIVATE_KEY_BUFFER_SIZE];
} CE2_ECPKI_PrivKey_t;

#endif /* ifndef _CE2_CONFIG_H*/
